import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.Random;
import java.util.List;
/**
 * Write a description of class Soldado here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Personaje extends Actor
{
    // instance variables - replace the example below with your own
    private int direccion;
    private Random r = new Random();
    protected int equipo;
    private int vida = 0;
    private int magia = 0;
    private int agua = 0;
    private int job;

    /**
     * Constructor for objects of class Soldado
     */    
    public Personaje()
    {
        establecerDireccion(r.nextInt(8) + 1);
    }
    
    //constructor
    public Personaje(int dir_x, int dir_y)
    {
        if(dir_x == 0 && dir_y == 1)
        {
            establecerDireccion(1);
        }
        else if(dir_x == 1 && dir_y == 1)
        {
            establecerDireccion(2);
        } 
        else if(dir_x == 1 && dir_y == 0)
        {
            establecerDireccion(3);
        }
        else if(dir_x == 1 && dir_y == -1)
        {
            establecerDireccion(4);
        } 
        else if(dir_x == 0 && dir_y == -1)
        {
            establecerDireccion(5);
        }
        else if(dir_x == -1 && dir_y == -1)
        {
            establecerDireccion(6);
        } 
        else if(dir_x == -1 && dir_y == 0)
        {
            establecerDireccion(7);
        }
        else if(dir_x == -1 && dir_y == 1)
        {
            establecerDireccion(8);
        }  
    }
    
    //funcion que se llama cada iteracion del juego
    public void act()
    {
        if(job == 1)
        {
            if(Greenfoot.isKeyDown("a"))
            {
               establecerDireccion(7);
            }
            
            if(Greenfoot.isKeyDown("s"))
            {
               establecerDireccion(5);
            }
            
            if(Greenfoot.isKeyDown("d"))
            {
               establecerDireccion(3);
            }
            
            if(Greenfoot.isKeyDown("w"))
            {
               establecerDireccion(1);
            }
        }
        
        moveCharacter();
    }
    
    //funcion que cambia la direccion del personaje cuando este alcanza los bordes del tablero
    public void moveCharacter()
    {        
       if(isAtEdge())
       {
           if(getX() == 9)
           {
               if(direccion == 4 || direccion == 2 || direccion == 3)
               {
                   newDirection();
               }
           } 
           if(getY() == 9)
           {
               if(direccion == 4 || direccion == 5 || direccion == 6)
               {
                   newDirection();
               }
           } 
           if(getX() == 0)
           {
               if(direccion == 6 || direccion == 7 || direccion == 8)
               {
                   newDirection();
               }
           } 
           if(getY() == 0)
           {
               if(direccion == 8 || direccion == 2 || direccion == 1)
               {
                   newDirection();
               }
           }
       }
        
        move(1);
        obstaculo();
    }
    
    //funcion que cambia la direccion del personaje si este choca con un obstaculo
    public void obstaculo()
    {
        if(isTouching(Obstaculo.class))
        {
            move(-1);
            newDirection();
        }        
    }
    
    //funcion que genera una nueva direccion aleatoriamente para los personajes
    public void newDirection()
    {
        int nueva_direccion = r.nextInt(8) + 1;
        if(direccion == nueva_direccion)
        {
            newDirection();
        } else
        {
            establecerDireccion(nueva_direccion);
        }
    }
    
    //funcion que hace al personaje cambiar su direccion a la siguiente direccion en el sentido de las agujas del reloj
    public void nextDir()
    {
        int aux;
        direccion += 4;
        if(direccion <= 8)
        {
            establecerDireccion(direccion);
        }
        else
        {
            aux = direccion-9;
            establecerDireccion((1 + aux));
        }
    }
    
    //funcion para cambiar la direccion de los personajes
    public void establecerDireccion(int dir)
    {
        switch(dir)
        {
            case 1:
                    setRotation(-90);
                    direccion = dir;
                break;
            case 5:
                    setRotation(90);
                    direccion = dir;
                break;
            case 7:
                    setRotation(-180);
                    direccion = dir;
                break;
            case 3:
                    setRotation(0);
                    direccion = dir;
                break;
            case 8:
                    setRotation(-135);
                    direccion = dir;
                break;
            case 4:
                    setRotation(45);
                    direccion = dir;
                break;
            case 2:
                    setRotation(-45);
                    direccion = dir;
                break;
            case 6:
                    setRotation(135);
                    direccion = dir;
                break;
            default:
                    System.out.println("ingrese un numero entre 1 y 8");
                break;              
        }
    }
           
    //funcion para restar vida al personaje cuando pierde la pelea
    public void perdio()
    {
        vida -= 20;
    }
    
    //funcion que devuelve la vida actual del personaje
    public int getVida()
    {
        return vida;
    }
    
    //funcion que devuelve verdadero si el personaje esta colisionando con otra entidad
    public boolean isTouching(java.lang.Class cls)
    {
       return super.isTouching(cls);
    }
        
    //funcion para curar a los campesinos y leñadores cuando pasan por una fruta
    public void curar()
    {
        if(vida <= 100)
        {
            vida += 20;
        }        
    }
        
    //devuelve un numero que indica el roll de cada personaje
    // 1 para la madre monte
    // 2 para el sacerdote
    // 3 para el niño
    // 4 para los campesinos
    // 5 para los leñadores
    public int getJob()
    {
        return job;
    }
    
    //funcion para establecer el roll de cada personaje
    // M para la madre monte
    // S para el sacerdote
    // N para el niño
    // C para los campesinos
    // L para los leñadores
    public void setJob(String new_job)
    {
        if(new_job.equals("M"))
        {
            job = 1;
            vida = 1000;
            setImage(new GreenfootImage("mmdiminuto.png"));
        }else
        if(new_job.equals("S"))
        {
            job = 2;
            vida = 100;
            setImage(new GreenfootImage("pdiminuto.png"));
        } else
        if(new_job.equals("N"))
        {
            job = 3;
            vida = 100;
            setImage(new GreenfootImage("niño.png"));
        } else
        if(new_job.equals("C"))
        {
            job = 4;
            vida = 100;
            setImage(new GreenfootImage("cdiminuto.png"));
        } else
        if(new_job.equals("L"))
        {
            job = 5;
            vida = 100;
            setImage(new GreenfootImage("leña.png"));
        }
    }
}
